#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Ponco {
    int w, v;
    int pocetni_indeks;
    double vrednost_po_jedinici_tezine;

    Ponco() {}

    Ponco(int _pocetni_indeks, int _w, int _v) {
        pocetni_indeks = _pocetni_indeks;
        w = _w;
        v = _v;
        vrednost_po_jedinici_tezine = 1.0d * v / w;
    }

    bool operator<(const Ponco& p) {
        return vrednost_po_jedinici_tezine < p.vrednost_po_jedinici_tezine;
    }
};

int main() {
    int N, W;
    double e;

    cin >> N >> W >> e;

    int w, v;
    vector<Ponco> ponco(N);

    for (int i = 0; i < N; i++) {
        cin >> w >> v;
        ponco[i] = Ponco(i, w, v);
    }

    sort(rbegin(ponco), rend(ponco));

    int ukupno_w = 0;
    vector<Ponco> kupljeni(0);

    for (int i = 0; i < N; i++) {
        if (ukupno_w + ponco[i].w > W) continue;

        kupljeni.emplace_back(ponco[i]);
        ukupno_w += ponco[i].w;

        if (ukupno_w == W) break;
    }

    int broj_kupljenih = kupljeni.size();
    cout << broj_kupljenih << endl;

    for (int i = 0; i < broj_kupljenih; i++) {
        cout << (kupljeni[i].pocetni_indeks + 1);
        if (i < broj_kupljenih - 1) cout << " ";
    }

    return 0;
}